def saisie_entier(message: str) -> int:
  """ Demande à l'utilisateur de saisir un nombre entier jusqu'à ce que la
  saisie soit valide.
  @param message l'invite / la question
  @return le nombre entier
  """
  valide = False
  while not valide:
    saisie = input(message)
    if saisie.isdigit():
      nombre = int(saisie)
      valide = True
    else:
      print("Erreur : '" + saisie + "' n'est pas un nombre.")
  return nombre


def saisie_nombre(message: str) -> float:
  """ Demande à l'utilisateur de saisir un nombre entier ou réel jusqu'à
  ce que la saisie soit valide.
  @param message l'invite / la question
  @return le nombre entier ou réel
  """
  valide = False
  while not valide:
    saisie = input(message).replace(",", ".")
    if saisie.replace(".", "", 1).isdigit():
      nombre = float(saisie) if "." in saisie else int(saisie)
      valide = True
    else:
      print("Erreur : '" + saisie + "' n'est pas un nombre.")
  return nombre

if __name__ == "__main__":
  nombre = saisie_nombre("Température : ")
  print("Vous avez saisi le nombre : " + str(nombre))
